// Filter Ash
__kernel void MAIN(__read_only image2d_t image1,   	// image buffer 1
				   __read_only image2d_t image2,   	// image buffer 2
				   __write_only image2d_t retImage, // image buffer for result
				   __global FilterParam* param,
				   __private int alpha)	 			// blend factor, scrope[0-100]	
{
	int w = get_global_id(0);
	int h = get_global_id(1);
	int width = param->width[0];;
	int height = param->height[0];;
	const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;
	
//	if(w < width && h < height)
	{
		float2 uv = (float2)((float)w / width, (float)h / height);
		float4 textureColor = read_imagef(image1, sampler, uv);
		
		float blueColor = textureColor.z * 63.0f;
		
		float2 quad1;
		quad1.y = floor(floor(blueColor) / 8.0f);
		quad1.x = floor(blueColor) - quad1.y * 8.0f;
		
		float2 quad2;
		quad2.y = floor(ceil(blueColor) / 8.0f);
		quad2.x = ceil(blueColor) - (quad2.y * 8.0f);
		
		float2 texPos1;
		texPos1.x = (quad1.x * 0.125f) + 0.5f/512.0f + ((0.125f - 1.0f/512.0f) * textureColor.x);
		texPos1.y = (quad1.y * 0.125f) + 0.5f/512.0f + ((0.125f - 1.0f/512.0f) * textureColor.y);
     
		float2 texPos2;
		texPos2.x = (quad2.x * 0.125f) + 0.5f/512.0f + ((0.125f - 1.0f/512.0f) * textureColor.x);
		texPos2.y = (quad2.y * 0.125f) + 0.5f/512.0f + ((0.125f - 1.0f/512.0f) * textureColor.y);
		
		uv = (float2)(texPos1.x, 1.0f - texPos1.y);
		float4 newColor1 = read_imagef(image2, sampler, uv);
		// translate newColor1 to bgra
		
		uv = (float2)(texPos2.x, 1.0f - texPos2.y);
		float4 newColor2 = read_imagef(image2, sampler, uv);
		
		float f = blueColor - floor(blueColor);
		float4 newColor = newColor1 * (1.0f - f) + newColor2 * f;		
	
		float factor = (float)(alpha)/100.0f;
		float4 color = ((float4)(newColor.xyz, textureColor.w)) * factor + textureColor * (1.0f - factor);	//bgra	
		
		write_imagef(retImage, (int2)(w, h), color);
	}
}







